/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.designer;

import filenet.sim.apps.designer.VWSIMDesignerCore;
import filenet.sim.apps.designer.images.VWSIMImageLoader;
import filenet.sim.apps.designer.resources.VWSIMResource;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWLogger;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseLaunchableApplication;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplashWindow;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Dimension;
import javax.swing.ImageIcon;

public class VWSIMDesignerApplication
extends VWBaseLaunchableApplication
implements IVWSplashWindowListener {
    private VWSIMDesignerCore m_designerCore = null;

    public static void main(String[] argv) {
        try {
            VWDebug.init(VWLogger.ERROR);
            VWCommandLineArgs args = new VWCommandLineArgs(argv);
            VWSessionInfo sessionInfo = new VWSessionInfo(null, null, args);
            if (!sessionInfo.verifyLogon(VWSIMResource.s_poDesignerGroup)) {
                System.exit(1);
            }
            VWSIMDesignerApplication app = new VWSIMDesignerApplication();
            app.init(sessionInfo);
            VWSIMHelp.init(app);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(VWSessionInfo sessionInfo) {
        try {
            super.init(sessionInfo);
            VWSplashWindow splashWindow = new VWSplashWindow(this);
            this.setTitle(VWIDMBaseFactory.instance().getVWString(12).toString());
            ImageIcon icon = VWSIMImageLoader.createImageIcon("simdesigner.gif");
            if (icon != null && icon.getImage() != null) {
                this.setIconImage(icon.getImage());
            }
            if (!this.updatePosition("sim_designer_location", "sim_designer_size")) {
                Dimension dim = VWStringUtils.stringToDimension("1024,768");
                if (dim == null) {
                    dim = new Dimension(1024, 768);
                }
                this.updatePosition(dim.width, dim.height);
            }
            this.setVisible(true);
            if (splashWindow != null) {
                splashWindow.start(this, 1000);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void startProcessing() {
        try {
            this.m_designerCore = new VWSIMDesignerCore();
            this.m_designerCore.init(this.m_sessionInfo);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean destroy() {
        boolean bResult = false;
        try {
            bResult = this.m_designerCore != null && !this.m_designerCore.destroy() ? false : super.destroy();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bResult;
    }
}

